/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.dangerous;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkeletonWeaponManager {
    private static final Map<UUID, Boolean> meleeMode = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastSwitchTick = new HashMap<UUID, Long>();
    private static final Map<UUID, ItemStack> stashedBow = new HashMap<UUID, ItemStack>();
    private static final long SWITCH_COOLDOWN_TICKS = 20L;
    private static final double MELEE_IN = 6.0;
    private static final double MELEE_OUT = 8.0;

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent event) {
        UUID id;
        AbstractSkeleton sk;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof AbstractSkeleton)) break block4;
                sk = (AbstractSkeleton)livingEntity;
                if (!sk.m_9236_().f_46443_) break block5;
            }
            return;
        }
        long now = sk.m_9236_().m_46467_();
        if (now - lastSwitchTick.getOrDefault(id = sk.m_20148_(), 0L) < 20L) {
            return;
        }
        this.updateSkeletonWeapon(sk);
        lastSwitchTick.put(id, now);
    }

    private void updateSkeletonWeapon(AbstractSkeleton sk) {
        boolean shouldMelee = this.shouldGoMelee(sk);
        UUID id = sk.m_20148_();
        if (meleeMode.getOrDefault(id, false) != shouldMelee) {
            if (shouldMelee) {
                this.switchToMelee(sk);
            } else {
                this.switchToRanged(sk);
            }
            this.forceAttackMode(sk, shouldMelee);
            meleeMode.put(id, shouldMelee);
        }
    }

    private boolean shouldGoMelee(AbstractSkeleton sk) {
        if (!SkeletonWeaponManager.hasMeleeWeapon(sk)) {
            return false;
        }
        LivingEntity tgt = sk.m_5448_();
        boolean nowMelee = meleeMode.getOrDefault(sk.m_20148_(), false);
        if (tgt == null || !tgt.m_6084_()) {
            List players = sk.m_9236_().m_6443_(Player.class, sk.m_20191_().m_82400_(6.0), EntitySelector.f_20408_);
            return !players.isEmpty();
        }
        double d = sk.m_20270_((Entity)tgt);
        boolean los = sk.m_142582_((Entity)tgt);
        if (!nowMelee) {
            return los && d <= 6.0;
        }
        return !(d >= 8.0) && los;
    }

    private static boolean isMelee(ItemStack s) {
        return !s.m_41619_() && (s.m_41720_() instanceof SwordItem || s.m_41720_() instanceof AxeItem);
    }

    private static boolean isBow(ItemStack s) {
        return !s.m_41619_() && s.m_41720_() instanceof BowItem;
    }

    private static boolean hasMeleeWeapon(AbstractSkeleton sk) {
        return SkeletonWeaponManager.isMelee(sk.m_21205_()) || SkeletonWeaponManager.isMelee(sk.m_21206_());
    }

    private void switchToMelee(AbstractSkeleton sk) {
        UUID id = sk.m_20148_();
        ItemStack main = sk.m_21205_();
        ItemStack off = sk.m_21206_();
        ItemStack foundBow = ItemStack.f_41583_;
        if (SkeletonWeaponManager.isBow(main)) {
            foundBow = main.m_41777_();
            sk.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        if (SkeletonWeaponManager.isBow(off)) {
            foundBow = off.m_41777_();
            sk.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
        if (!foundBow.m_41619_()) {
            stashedBow.put(id, foundBow);
        }
        main = sk.m_21205_();
        off = sk.m_21206_();
        if (!SkeletonWeaponManager.isMelee(main) && SkeletonWeaponManager.isMelee(off)) {
            sk.m_8061_(EquipmentSlot.MAINHAND, off.m_41777_());
            sk.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
    }

    private void switchToRanged(AbstractSkeleton sk) {
        ItemStack melee;
        UUID id = sk.m_20148_();
        ItemStack bow = stashedBow.getOrDefault(id, ItemStack.f_41583_);
        if (bow.m_41619_()) {
            if (SkeletonWeaponManager.isBow(sk.m_21205_())) {
                bow = sk.m_21205_().m_41777_();
            } else if (SkeletonWeaponManager.isBow(sk.m_21206_())) {
                bow = sk.m_21206_().m_41777_();
            }
        }
        ItemStack main = sk.m_21205_();
        ItemStack off = sk.m_21206_();
        ItemStack itemStack = SkeletonWeaponManager.isMelee(main) ? main.m_41777_() : (melee = SkeletonWeaponManager.isMelee(off) ? off.m_41777_() : ItemStack.f_41583_);
        if (!bow.m_41619_()) {
            sk.m_8061_(EquipmentSlot.MAINHAND, bow.m_41777_());
            stashedBow.remove(id);
        }
        if (!melee.m_41619_() && !SkeletonWeaponManager.isBow(melee)) {
            sk.m_8061_(EquipmentSlot.OFFHAND, melee);
        } else if (SkeletonWeaponManager.isBow(off)) {
            sk.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
    }

    private void forceAttackMode(AbstractSkeleton sk, boolean melee) {
        sk.m_5810_();
        RangedBowAttackGoal ranged = null;
        MeleeAttackGoal meleeGoal = null;
        for (WrappedGoal wg : sk.f_21345_.m_148105_()) {
            MeleeAttackGoal mg;
            Goal g = wg.m_26015_();
            if (g instanceof RangedBowAttackGoal) {
                RangedBowAttackGoal rg;
                ranged = rg = (RangedBowAttackGoal)g;
                continue;
            }
            if (!(g instanceof MeleeAttackGoal)) continue;
            meleeGoal = mg = (MeleeAttackGoal)g;
        }
        if (ranged != null) {
            sk.f_21345_.m_25363_(ranged);
        }
        if (meleeGoal != null) {
            sk.f_21345_.m_25363_(meleeGoal);
        }
        if (melee) {
            sk.f_21345_.m_25352_(4, (Goal)new NoPoseMeleeAttackGoal(sk, 1.2, false));
        } else {
            sk.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)sk, 1.0, 20, 15.0f));
        }
        sk.m_21561_(false);
        sk.m_21573_().m_26573_();
    }

    private static class NoPoseMeleeAttackGoal
    extends MeleeAttackGoal {
        private final AbstractSkeleton skel;

        public NoPoseMeleeAttackGoal(AbstractSkeleton mob, double speed, boolean longMemory) {
            super((PathfinderMob)mob, speed, longMemory);
            this.skel = mob;
        }

        public void m_8056_() {
            super.m_8056_();
            this.skel.m_21561_(false);
        }

        public void m_8041_() {
            super.m_8041_();
            this.skel.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            this.skel.m_21561_(false);
        }
    }
}

